;
;
;***********************
;     DEMO DC MOTOR    *
;     EXPERIMENT 5     *
;***********************

           CPU "Z180.TBL"
           HOF "INT8"
           ORG 8000H

MOTRIGHT:  EQU 00100000B      ;PA5=1,PA4=0 RIGHT MOMENT
MOTLEFT:   EQU 01000000B
CNTRL:     EQU 0B7H
MOTOR:     EQU 0B6H
;
SCANK:     EQU 0102H
GOTO_ADDR: EQU 010DH
WRLCD:     EQU 010EH
LCDHEX:    EQU 0114H
CLR_LCD:   EQU 0117H
CUR_OFF:   EQU 0119H
HTOA:      EQU 011DH
HEXDEC:    EQU 0120H
PRINT:     EQU 0126H
DMSEC:     EQU 012EH
;
LEFT:      EQU 4
RIGHT:     EQU 5
UP:        EQU 2
DOWN:      EQU 3
;
START:    LD   A,10010011B    ;INITIAL
          OUT  (CNTRL),A
          LD   A,MOTRIGHT     ;LOAD DIR
          LD   (DIR_MOT),A
          LD   HL,7F7EH
          LD   (BLNK_R),HL
;
          LD   HL,0C040H
          LD   (TIMEON),HL

START0:   CALL CLR_LCD
          CALL CUR_OFF
          LD   DE,TAB_NAME
          CALL PRINT

          LD   HL,TIMEON
          LD   IX,TIMEOFF
          CALL TIME_DSP
;
START1:   LD   A,(DIR_MOT)
          SET  7,A           ;DC MOTOR ON  (PA6)
          OUT  (MOTOR),A
          CALL DELON         ;SPEED
          RES  7,A           ;DC MOTOR OFF (PA6)
          OUT  (MOTOR),A
          CALL DELOFF
          CALL BLINK
;
START2:   CALL SCANK         ;SPEED CONTROL
          CP   UP
          JP   Z,INCR
          CP   DOWN
          JP   Z,DECR
          CP   LEFT
          JR   Z,MOT_LEFT
          CP   RIGHT
          JR   Z,MOT_RIGHT
          CP   0FFH
          JR   NZ,START2
          JR   START1
;
MOT_LEFT: LD   A,MOTLEFT
          LD   (DIR_MOT),A
          JR   START0
;
MOT_RIGHT:
          LD   A,MOTRIGHT
          LD   (DIR_MOT),A
          JR   START0

INCR:     LD   HL,TIMEON
          LD   IX,TIMEOFF
          LD   A,255
          CP   (HL)
          JP   Z,START2
          INC  (HL)
          DEC  (IX+0)
          CALL TIME_DSP
          JP   START2

;
DECR:     LD   HL,TIMEON
          LD   IX,TIMEOFF
          LD   A,1
          CP   (HL)
          JP   Z,START2
          DEC  (HL)
          INC  (IX+0)
          CALL TIME_DSP
          JP   START2

;*** SPEED OF MOTOR ***

DELON:    LD   A,(TIMEON)
          LD   B,A
          CALL DMSEC
          RET
;
DELOFF:   LD   A,(TIMEOFF)
          LD   B,A
          CALL DMSEC
          RET
;
CHNG_DAT: LD   E,A
          LD   D,0
          CALL HEXDEC
          LD   A,B
          ADD  A,"0"
          LD   B,A
          RET
;
TIME_DSP: LD   A,(HL)
          CALL CHNG_DAT
          LD   D,4
          CALL PRINT_V
          LD   A,(IX+0)
          CALL CHNG_DAT
          LD   D,11
          CALL PRINT_V
          RET
;
PRINT_V:  CALL GOTO_ADDR
          LD   D,B
          CALL WRLCD
          LD   D,C
          CALL LCDHEX
          RET
;
BLINK:    LD   HL,BLNK_R
          LD   D,15
          LD   A,(DIR_MOT)
          BIT  6,A
          LD   A,5EH
          JR   Z,BLINK1

          LD   HL,BLNK_L
          LD   D,0
          LD   A,5FH
BLINK1:   XOR  (HL)
          LD   (HL),A
          CALL GOTO_ADDR
          LD   D,(HL)
          CALL WRLCD
          RET
;
TAB_NAME: DFB  "  H=     L=",0

          ORG   0F000H
TIMEON:   DFS   1
TIMEOFF:  DFS   1
DIR_MOT:  DFS   1
BLNK_R:   DFS   1
BLNK_L:   DFS   1

          END



